package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ScopeRestrictionBuilder extends ScopeRestrictionFluentImpl<ScopeRestrictionBuilder> implements VisitableBuilder<ScopeRestriction,ScopeRestrictionBuilder>{

    ScopeRestrictionFluent<?> fluent;
    Boolean validationEnabled;

    public ScopeRestrictionBuilder(){
            this(true);
    }
    public ScopeRestrictionBuilder(Boolean validationEnabled){
            this(new ScopeRestriction(), validationEnabled);
    }
    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent){
            this(fluent, true);
    }
    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ScopeRestriction(), validationEnabled);
    }
    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,ScopeRestriction instance){
            this(fluent, instance, true);
    }
    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent,ScopeRestriction instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClusterRole(instance.getClusterRole()); 
            fluent.withLiterals(instance.getLiterals()); 
            this.validationEnabled = validationEnabled; 
    }
    public ScopeRestrictionBuilder(ScopeRestriction instance){
            this(instance,true);
    }
    public ScopeRestrictionBuilder(ScopeRestriction instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClusterRole(instance.getClusterRole()); 
            this.withLiterals(instance.getLiterals()); 
            this.validationEnabled = validationEnabled; 
    }

    public ScopeRestriction build(){
            ScopeRestriction buildable = new ScopeRestriction(fluent.getClusterRole(),fluent.getLiterals());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ScopeRestrictionBuilder that = (ScopeRestrictionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
