package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SubjectAccessReviewBuilder extends SubjectAccessReviewFluentImpl<SubjectAccessReviewBuilder> implements VisitableBuilder<SubjectAccessReview,SubjectAccessReviewBuilder>{

    SubjectAccessReviewFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectAccessReviewBuilder(){
            this(true);
    }
    public SubjectAccessReviewBuilder(Boolean validationEnabled){
            this(new SubjectAccessReview(), validationEnabled);
    }
    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent){
            this(fluent, true);
    }
    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubjectAccessReview(), validationEnabled);
    }
    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance){
            this(fluent, instance, true);
    }
    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withContent(instance.getContent()); 
            fluent.withGroups(instance.getGroups()); 
            fluent.withKind(instance.getKind()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withResource(instance.getResource()); 
            fluent.withResourceAPIGroup(instance.getResourceAPIGroup()); 
            fluent.withResourceAPIVersion(instance.getResourceAPIVersion()); 
            fluent.withResourceName(instance.getResourceName()); 
            fluent.withScopes(instance.getScopes()); 
            fluent.withUser(instance.getUser()); 
            fluent.withVerb(instance.getVerb()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectAccessReviewBuilder(SubjectAccessReview instance){
            this(instance,true);
    }
    public SubjectAccessReviewBuilder(SubjectAccessReview instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withContent(instance.getContent()); 
            this.withGroups(instance.getGroups()); 
            this.withKind(instance.getKind()); 
            this.withNamespace(instance.getNamespace()); 
            this.withResource(instance.getResource()); 
            this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
            this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
            this.withResourceName(instance.getResourceName()); 
            this.withScopes(instance.getScopes()); 
            this.withUser(instance.getUser()); 
            this.withVerb(instance.getVerb()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubjectAccessReview build(){
            SubjectAccessReview buildable = new SubjectAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getGroups(),fluent.getKind(),fluent.getNamespace(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getScopes(),fluent.getUser(),fluent.getVerb());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectAccessReviewBuilder that = (SubjectAccessReviewBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
