/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.DockerConfig;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "Architecture", "Author", "Comment", "Config", "Container", "ContainerConfig", "Created", "DockerVersion", "Id", "Parent", "Size"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class DockerImage
implements KubernetesResource {
    @JsonProperty(value="Architecture")
    private String architecture;
    @JsonProperty(value="Author")
    private String author;
    @JsonProperty(value="Comment")
    private String comment;
    @JsonProperty(value="Config")
    @Valid
    private DockerConfig config;
    @JsonProperty(value="Container")
    private String container;
    @JsonProperty(value="ContainerConfig")
    @Valid
    private DockerConfig containerConfig;
    @JsonProperty(value="Created")
    private String created;
    @JsonProperty(value="DockerVersion")
    private String dockerVersion;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Parent")
    private String parent;
    @JsonProperty(value="Size")
    private Long size;
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "image/api";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "DockerImage";
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DockerImage() {
    }

    public DockerImage(String architecture, String author, String comment, DockerConfig config, String container, DockerConfig containerConfig, String created, String dockerVersion, String id, String parent, Long size, String apiVersion, String kind) {
        this.architecture = architecture;
        this.author = author;
        this.comment = comment;
        this.config = config;
        this.container = container;
        this.containerConfig = containerConfig;
        this.created = created;
        this.dockerVersion = dockerVersion;
        this.id = id;
        this.parent = parent;
        this.size = size;
        this.apiVersion = apiVersion;
        this.kind = kind;
    }

    @JsonProperty(value="Architecture")
    public String getArchitecture() {
        return this.architecture;
    }

    @JsonProperty(value="Architecture")
    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    @JsonProperty(value="Author")
    public String getAuthor() {
        return this.author;
    }

    @JsonProperty(value="Author")
    public void setAuthor(String author) {
        this.author = author;
    }

    @JsonProperty(value="Comment")
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="Comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonProperty(value="Config")
    public DockerConfig getConfig() {
        return this.config;
    }

    @JsonProperty(value="Config")
    public void setConfig(DockerConfig config) {
        this.config = config;
    }

    @JsonProperty(value="Container")
    public String getContainer() {
        return this.container;
    }

    @JsonProperty(value="Container")
    public void setContainer(String container) {
        this.container = container;
    }

    @JsonProperty(value="ContainerConfig")
    public DockerConfig getContainerConfig() {
        return this.containerConfig;
    }

    @JsonProperty(value="ContainerConfig")
    public void setContainerConfig(DockerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    @JsonProperty(value="Created")
    public String getCreated() {
        return this.created;
    }

    @JsonProperty(value="Created")
    public void setCreated(String created) {
        this.created = created;
    }

    @JsonProperty(value="DockerVersion")
    public String getDockerVersion() {
        return this.dockerVersion;
    }

    @JsonProperty(value="DockerVersion")
    public void setDockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
    }

    @JsonProperty(value="Id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="Id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="Parent")
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="Parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    @JsonProperty(value="Size")
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="Size")
    public void setSize(Long size) {
        this.size = size;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "DockerImage(architecture=" + this.getArchitecture() + ", author=" + this.getAuthor() + ", comment=" + this.getComment() + ", config=" + this.getConfig() + ", container=" + this.getContainer() + ", containerConfig=" + this.getContainerConfig() + ", created=" + this.getCreated() + ", dockerVersion=" + this.getDockerVersion() + ", id=" + this.getId() + ", parent=" + this.getParent() + ", size=" + this.getSize() + ", apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerImage)) {
            return false;
        }
        DockerImage other = (DockerImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$architecture = this.getArchitecture();
        String other$architecture = other.getArchitecture();
        if (this$architecture == null ? other$architecture != null : !this$architecture.equals(other$architecture)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        DockerConfig this$config = this.getConfig();
        DockerConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$container = this.getContainer();
        String other$container = other.getContainer();
        if (this$container == null ? other$container != null : !this$container.equals(other$container)) {
            return false;
        }
        DockerConfig this$containerConfig = this.getContainerConfig();
        DockerConfig other$containerConfig = other.getContainerConfig();
        if (this$containerConfig == null ? other$containerConfig != null : !((Object)this$containerConfig).equals(other$containerConfig)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$dockerVersion = this.getDockerVersion();
        String other$dockerVersion = other.getDockerVersion();
        if (this$dockerVersion == null ? other$dockerVersion != null : !this$dockerVersion.equals(other$dockerVersion)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $architecture = this.getArchitecture();
        result = result * 59 + ($architecture == null ? 43 : $architecture.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        DockerConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : $container.hashCode());
        DockerConfig $containerConfig = this.getContainerConfig();
        result = result * 59 + ($containerConfig == null ? 43 : ((Object)$containerConfig).hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $dockerVersion = this.getDockerVersion();
        result = result * 59 + ($dockerVersion == null ? 43 : $dockerVersion.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

