/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DockerConfig;
import io.fabric8.openshift.api.model.DockerConfigBuilder;
import io.fabric8.openshift.api.model.DockerConfigFluentImpl;
import io.fabric8.openshift.api.model.DockerImage;
import io.fabric8.openshift.api.model.DockerImageFluent;

public class DockerImageFluentImpl<A extends DockerImageFluent<A>>
extends BaseFluent<A>
implements DockerImageFluent<A> {
    private String architecture;
    private String author;
    private String comment;
    private VisitableBuilder<? extends DockerConfig, ?> config;
    private String container;
    private VisitableBuilder<? extends DockerConfig, ?> containerConfig;
    private String created;
    private String dockerVersion;
    private String id;
    private String parent;
    private Long size;
    private String apiVersion;
    private String kind;

    public DockerImageFluentImpl() {
    }

    public DockerImageFluentImpl(DockerImage instance) {
        this.withArchitecture(instance.getArchitecture());
        this.withAuthor(instance.getAuthor());
        this.withComment(instance.getComment());
        this.withConfig(instance.getConfig());
        this.withContainer(instance.getContainer());
        this.withContainerConfig(instance.getContainerConfig());
        this.withCreated(instance.getCreated());
        this.withDockerVersion(instance.getDockerVersion());
        this.withId(instance.getId());
        this.withParent(instance.getParent());
        this.withSize(instance.getSize());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)this;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public A withAuthor(String author) {
        this.author = author;
        return (A)this;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public A withComment(String comment) {
        this.comment = comment;
        return (A)this;
    }

    @Override
    public DockerConfig getConfig() {
        return this.config != null ? (DockerConfig)this.config.build() : null;
    }

    @Override
    public A withConfig(DockerConfig config) {
        this._visitables.remove(this.config);
        if (config != null) {
            this.config = new DockerConfigBuilder(config);
            this._visitables.add(this.config);
        }
        return (A)this;
    }

    @Override
    public DockerImageFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public DockerImageFluent.ConfigNested<A> withNewConfigLike(DockerConfig item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public DockerImageFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public DockerImageFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new DockerConfigBuilder().build());
    }

    @Override
    public DockerImageFluent.ConfigNested<A> editOrNewConfigLike(DockerConfig item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public DockerConfig getContainerConfig() {
        return this.containerConfig != null ? (DockerConfig)this.containerConfig.build() : null;
    }

    @Override
    public A withContainerConfig(DockerConfig containerConfig) {
        this._visitables.remove(this.containerConfig);
        if (containerConfig != null) {
            this.containerConfig = new DockerConfigBuilder(containerConfig);
            this._visitables.add(this.containerConfig);
        }
        return (A)this;
    }

    @Override
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfig() {
        return new ContainerConfigNestedImpl();
    }

    @Override
    public DockerImageFluent.ContainerConfigNested<A> withNewContainerConfigLike(DockerConfig item) {
        return new ContainerConfigNestedImpl(item);
    }

    @Override
    public DockerImageFluent.ContainerConfigNested<A> editContainerConfig() {
        return this.withNewContainerConfigLike(this.getContainerConfig());
    }

    @Override
    public DockerImageFluent.ContainerConfigNested<A> editOrNewContainerConfig() {
        return this.withNewContainerConfigLike(this.getContainerConfig() != null ? this.getContainerConfig() : new DockerConfigBuilder().build());
    }

    @Override
    public DockerImageFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(DockerConfig item) {
        return this.withNewContainerConfigLike(this.getContainerConfig() != null ? this.getContainerConfig() : item);
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    @Override
    public A withCreated(String created) {
        this.created = created;
        return (A)this;
    }

    @Override
    public String getDockerVersion() {
        return this.dockerVersion;
    }

    @Override
    public A withDockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
        return (A)this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public A withParent(String parent) {
        this.parent = parent;
        return (A)this;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public A withSize(Long size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerImageFluentImpl that = (DockerImageFluentImpl)o;
        if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) {
            return false;
        }
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.containerConfig != null ? !this.containerConfig.equals(that.containerConfig) : that.containerConfig != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.dockerVersion != null ? !this.dockerVersion.equals(that.dockerVersion) : that.dockerVersion != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }

    public class ContainerConfigNestedImpl<N>
    extends DockerConfigFluentImpl<DockerImageFluent.ContainerConfigNested<N>>
    implements DockerImageFluent.ContainerConfigNested<N>,
    Nested<N> {
        private final DockerConfigBuilder builder;

        ContainerConfigNestedImpl(DockerConfig item) {
            this.builder = new DockerConfigBuilder(this, item);
        }

        ContainerConfigNestedImpl() {
            this.builder = new DockerConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerImageFluentImpl.this.withContainerConfig(this.builder.build());
        }

        @Override
        public N endContainerConfig() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends DockerConfigFluentImpl<DockerImageFluent.ConfigNested<N>>
    implements DockerImageFluent.ConfigNested<N>,
    Nested<N> {
        private final DockerConfigBuilder builder;

        ConfigNestedImpl(DockerConfig item) {
            this.builder = new DockerConfigBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new DockerConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerImageFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

