package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ContextFluentImpl<A extends ContextFluent<A>> extends BaseFluent<A> implements ContextFluent<A>{

    private String cluster;
    private List<VisitableBuilder<? extends NamedExtension,?>> extensions =  new ArrayList<VisitableBuilder<? extends NamedExtension,?>>();
    private String namespace;
    private String user;

    public ContextFluentImpl(){
    }
    public ContextFluentImpl(Context instance){
            this.withCluster(instance.getCluster()); 
            this.withExtensions(instance.getExtensions()); 
            this.withNamespace(instance.getNamespace()); 
            this.withUser(instance.getUser()); 
    }

    public String getCluster(){
            return this.cluster;
    }

    public A withCluster(String cluster){
            this.cluster=cluster; return (A) this;
    }

    public A addToExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }

    public List<NamedExtension> getExtensions(){
            return build(extensions);
    }

    public A withExtensions(List<NamedExtension> extensions){
            this.extensions.clear();
            if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions){
            this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public ContextFluent.ExtensionsNested<A> addNewExtension(){
            return new ExtensionsNestedImpl();
    }

    public ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item){
            return new ExtensionsNestedImpl(item);
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContextFluentImpl that = (ContextFluentImpl) o;
            if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
            if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ContextFluent.ExtensionsNested<N>> implements ContextFluent.ExtensionsNested<N>,Nested<N>{

            private final NamedExtensionBuilder builder;
    
            ExtensionsNestedImpl(){
                    this.builder = new NamedExtensionBuilder(this);
            }
            ExtensionsNestedImpl(NamedExtension item){
                    this.builder = new NamedExtensionBuilder(this, item);
            }
    
    public N and(){
            return (N) ContextFluentImpl.this.addToExtensions(builder.build());
    }
    public N endExtension(){
            return and();
    }

}


}
