package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class DaemonEndpointBuilder extends DaemonEndpointFluentImpl<DaemonEndpointBuilder> implements VisitableBuilder<DaemonEndpoint,DaemonEndpointBuilder>{

    DaemonEndpointFluent<?> fluent;
    Boolean validationEnabled;

    public DaemonEndpointBuilder(){
            this(true);
    }
    public DaemonEndpointBuilder(Boolean validationEnabled){
            this(new DaemonEndpoint(), validationEnabled);
    }
    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent){
            this(fluent, true);
    }
    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DaemonEndpoint(), validationEnabled);
    }
    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,DaemonEndpoint instance){
            this(fluent, instance, true);
    }
    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,DaemonEndpoint instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public DaemonEndpointBuilder(DaemonEndpoint instance){
            this(instance,true);
    }
    public DaemonEndpointBuilder(DaemonEndpoint instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }

    public DaemonEndpoint build(){
            DaemonEndpoint buildable = new DaemonEndpoint(fluent.getPort());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonEndpointBuilder that = (DaemonEndpointBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
