package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface HTTPGetActionFluent<A extends HTTPGetActionFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public A addToHttpHeaders(HTTPHeader... items);
    public A removeFromHttpHeaders(HTTPHeader... items);
    public List<HTTPHeader> getHttpHeaders();
    public A withHttpHeaders(List<HTTPHeader> httpHeaders);
    public A withHttpHeaders(HTTPHeader... httpHeaders);
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader();
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item);
    public A addNewHttpHeader(String name,String value);
    public String getPath();
    public A withPath(String path);
    public IntOrString getPort();
    public A withPort(IntOrString port);
    public HTTPGetActionFluent.PortNested<A> withNewPort();
    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item);
    public HTTPGetActionFluent.PortNested<A> editPort();
    public A withNewPort(String strVal);
    public A withNewPort(Integer intVal);
    public String getScheme();
    public A withScheme(String scheme);

    public interface HttpHeadersNested<N> extends Nested<N>,HTTPHeaderFluent<HTTPGetActionFluent.HttpHeadersNested<N>>{

        
    public N endHttpHeader();    public N and();
}
    public interface PortNested<N> extends Nested<N>,IntOrStringFluent<HTTPGetActionFluent.PortNested<N>>{

        
    public N endPort();    public N and();
}


}
