package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface LabelSelectorFluent<A extends LabelSelectorFluent<A>> extends Fluent<A>{


    public A addToMatchExpressions(LabelSelectorRequirement... items);
    public A removeFromMatchExpressions(LabelSelectorRequirement... items);
    public List<LabelSelectorRequirement> getMatchExpressions();
    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions);
    public A withMatchExpressions(LabelSelectorRequirement... matchExpressions);
    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression();
    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item);
    public A addToMatchLabels(String key,String value);
    public A addToMatchLabels(Map<String,String> map);
    public A removeFromMatchLabels(String key);
    public A removeFromMatchLabels(Map<String,String> map);
    public Map<String,String> getMatchLabels();
    public A withMatchLabels(Map<String,String> matchLabels);

    public interface MatchExpressionsNested<N> extends Nested<N>,LabelSelectorRequirementFluent<LabelSelectorFluent.MatchExpressionsNested<N>>{

        
    public N endMatchExpression();    public N and();
}


}
