package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class LabelSelectorRequirementBuilder extends LabelSelectorRequirementFluentImpl<LabelSelectorRequirementBuilder> implements VisitableBuilder<LabelSelectorRequirement,LabelSelectorRequirementBuilder>{

    LabelSelectorRequirementFluent<?> fluent;
    Boolean validationEnabled;

    public LabelSelectorRequirementBuilder(){
            this(true);
    }
    public LabelSelectorRequirementBuilder(Boolean validationEnabled){
            this(new LabelSelectorRequirement(), validationEnabled);
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent){
            this(fluent, true);
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LabelSelectorRequirement(), validationEnabled);
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,LabelSelectorRequirement instance){
            this(fluent, instance, true);
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,LabelSelectorRequirement instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey()); 
            fluent.withOperator(instance.getOperator()); 
            fluent.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance){
            this(instance,true);
    }
    public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey()); 
            this.withOperator(instance.getOperator()); 
            this.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }

    public LabelSelectorRequirement build(){
            LabelSelectorRequirement buildable = new LabelSelectorRequirement(fluent.getKey(),fluent.getOperator(),fluent.getValues());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LabelSelectorRequirementBuilder that = (LabelSelectorRequirementBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
