package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class LoadBalancerStatusFluentImpl<A extends LoadBalancerStatusFluent<A>> extends BaseFluent<A> implements LoadBalancerStatusFluent<A>{

    private List<VisitableBuilder<? extends LoadBalancerIngress,?>> ingress =  new ArrayList<VisitableBuilder<? extends LoadBalancerIngress,?>>();

    public LoadBalancerStatusFluentImpl(){
    }
    public LoadBalancerStatusFluentImpl(LoadBalancerStatus instance){
            this.withIngress(instance.getIngress()); 
    }

    public A addToIngress(LoadBalancerIngress... items){
            for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(LoadBalancerIngress... items){
            for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }

    public List<LoadBalancerIngress> getIngress(){
            return build(ingress);
    }

    public A withIngress(List<LoadBalancerIngress> ingress){
            this.ingress.clear();
            if (ingress != null) {for (LoadBalancerIngress item : ingress){this.addToIngress(item);}} return (A) this;
    }

    public A withIngress(LoadBalancerIngress... ingress){
            this.ingress.clear(); if (ingress != null) {for (LoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public LoadBalancerStatusFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(LoadBalancerIngress item){
            return new IngressNestedImpl(item);
    }

    public A addNewIngress(String hostname,String ip){
            return (A)addToIngress(new LoadBalancerIngress(hostname, ip));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl) o;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            return true;
    }


    public class IngressNestedImpl<N> extends LoadBalancerIngressFluentImpl<LoadBalancerStatusFluent.IngressNested<N>> implements LoadBalancerStatusFluent.IngressNested<N>,Nested<N>{

            private final LoadBalancerIngressBuilder builder;
    
            IngressNestedImpl(){
                    this.builder = new LoadBalancerIngressBuilder(this);
            }
            IngressNestedImpl(LoadBalancerIngress item){
                    this.builder = new LoadBalancerIngressBuilder(this, item);
            }
    
    public N endIngress(){
            return and();
    }
    public N and(){
            return (N) LoadBalancerStatusFluentImpl.this.addToIngress(builder.build());
    }

}


}
