package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotNull;

public interface ObjectReferenceFluent<A extends ObjectReferenceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getFieldPath();
    public A withFieldPath(String fieldPath);
    public String getKind();
    public A withKind(String kind);
    public String getName();
    public A withName(String name);
    public String getNamespace();
    public A withNamespace(String namespace);
    public String getResourceVersion();
    public A withResourceVersion(String resourceVersion);
    public String getUid();
    public A withUid(String uid);



}
