package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceAccountListFluent<A extends ServiceAccountListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ServiceAccount... items);
    public A removeFromItems(ServiceAccount... items);
    public List<ServiceAccount> getItems();
    public A withItems(List<ServiceAccount> items);
    public A withItems(ServiceAccount... items);
    public ServiceAccountListFluent.ItemsNested<A> addNewItem();
    public ServiceAccountListFluent.ItemsNested<A> addNewItemLike(ServiceAccount item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadata();
    public ServiceAccountListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ServiceAccountListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServiceAccountFluent<ServiceAccountListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ServiceAccountListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
