package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ServiceAccountListFluentImpl<A extends ServiceAccountListFluent<A>> extends BaseFluent<A> implements ServiceAccountListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends ServiceAccount,?>> items =  new ArrayList<VisitableBuilder<? extends ServiceAccount,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public ServiceAccountListFluentImpl(){
    }
    public ServiceAccountListFluentImpl(ServiceAccountList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<ServiceAccount> getItems(){
            return build(items);
    }

    public A withItems(List<ServiceAccount> items){
            this.items.clear();
            if (items != null) {for (ServiceAccount item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(ServiceAccount... items){
            this.items.clear(); if (items != null) {for (ServiceAccount item :items){ this.addToItems(item);}} return (A) this;
    }

    public ServiceAccountListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ServiceAccountListFluent.ItemsNested<A> addNewItemLike(ServiceAccount item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ServiceAccountListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ServiceAccountListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public ServiceAccountListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceAccountListFluentImpl that = (ServiceAccountListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ServiceAccountFluentImpl<ServiceAccountListFluent.ItemsNested<N>> implements ServiceAccountListFluent.ItemsNested<N>,Nested<N>{

            private final ServiceAccountBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new ServiceAccountBuilder(this);
            }
            ItemsNestedImpl(ServiceAccount item){
                    this.builder = new ServiceAccountBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) ServiceAccountListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<ServiceAccountListFluent.MetadataNested<N>> implements ServiceAccountListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) ServiceAccountListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
