package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class TCPSocketActionFluentImpl<A extends TCPSocketActionFluent<A>> extends BaseFluent<A> implements TCPSocketActionFluent<A>{

    private VisitableBuilder<? extends IntOrString,?> port;

    public TCPSocketActionFluentImpl(){
    }
    public TCPSocketActionFluentImpl(TCPSocketAction instance){
            this.withPort(instance.getPort()); 
    }

    public IntOrString getPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(IntOrString port){
            if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (A) this;
    }

    public TCPSocketActionFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public TCPSocketActionFluent.PortNested<A> withNewPortLike(IntOrString item){
            return new PortNestedImpl(item);
    }

    public TCPSocketActionFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public A withNewPort(String strVal){
            return (A)withPort(new IntOrString(strVal));
    }

    public A withNewPort(Integer intVal){
            return (A)withPort(new IntOrString(intVal));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPSocketActionFluentImpl that = (TCPSocketActionFluentImpl) o;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends IntOrStringFluentImpl<TCPSocketActionFluent.PortNested<N>> implements TCPSocketActionFluent.PortNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            PortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            PortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N endPort(){
            return and();
    }
    public N and(){
            return (N) TCPSocketActionFluentImpl.this.withPort(builder.build());
    }

}


}
