package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface DeploymentStatusFluent<A extends DeploymentStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getUnavailableReplicas();
    public A withUnavailableReplicas(Integer unavailableReplicas);
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);



}
