package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class ReplicaSetStatusBuilder extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder> implements VisitableBuilder<ReplicaSetStatus,ReplicaSetStatusBuilder>{

    ReplicaSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicaSetStatusBuilder(){
            this(true);
    }
    public ReplicaSetStatusBuilder(Boolean validationEnabled){
            this(new ReplicaSetStatus(), validationEnabled);
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReplicaSetStatus(), validationEnabled);
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,ReplicaSetStatus instance){
            this(fluent, instance, true);
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,ReplicaSetStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatus instance){
            this(instance,true);
    }
    public ReplicaSetStatusBuilder(ReplicaSetStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReplicaSetStatus build(){
            ReplicaSetStatus buildable = new ReplicaSetStatus(fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReplicas());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
