package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.Map;
import javax.validation.Valid;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ScaleStatusFluent<A extends ScaleStatusFluent<A>> extends Fluent<A>{


    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public String getTargetSelector();
    public A withTargetSelector(String targetSelector);



}
