package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public DeploymentStrategy getStrategy();
    public A withStrategy(DeploymentStrategy strategy);
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy();
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
    public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate();
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate();
    public Boolean isTest();
    public A withTest(Boolean test);
    public A addToTriggers(DeploymentTriggerPolicy... items);
    public A removeFromTriggers(DeploymentTriggerPolicy... items);
    public List<DeploymentTriggerPolicy> getTriggers();
    public A withTriggers(List<DeploymentTriggerPolicy> triggers);
    public A withTriggers(DeploymentTriggerPolicy... triggers);
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item);

    public interface StrategyNested<N> extends Nested<N>,DeploymentStrategyFluent<DeploymentConfigSpecFluent.StrategyNested<N>>{

        
    public N endStrategy();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<DeploymentConfigSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}
    public interface TriggersNested<N> extends Nested<N>,DeploymentTriggerPolicyFluent<DeploymentConfigSpecFluent.TriggersNested<N>>{

        
    public N endTrigger();    public N and();
}


}
