package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface GitHubWebHookCauseFluent<A extends GitHubWebHookCauseFluent<A>> extends Fluent<A>{


    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public GitHubWebHookCauseFluent.RevisionNested<A> withNewRevision();
    public GitHubWebHookCauseFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public GitHubWebHookCauseFluent.RevisionNested<A> editRevision();
    public String getSecret();
    public A withSecret(String secret);

    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<GitHubWebHookCauseFluent.RevisionNested<N>>{

        
    public N endRevision();    public N and();
}


}
