package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class GroupListFluentImpl<A extends GroupListFluent<A>> extends BaseFluent<A> implements GroupListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Group,?>> items =  new ArrayList<VisitableBuilder<? extends Group,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public GroupListFluentImpl(){
    }
    public GroupListFluentImpl(GroupList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Group> getItems(){
            return build(items);
    }

    public A withItems(List<Group> items){
            this.items.clear();
            if (items != null) {for (Group item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Group... items){
            this.items.clear(); if (items != null) {for (Group item :items){ this.addToItems(item);}} return (A) this;
    }

    public GroupListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public GroupListFluent.ItemsNested<A> addNewItemLike(Group item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public GroupListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public GroupListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public GroupListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GroupListFluentImpl that = (GroupListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends GroupFluentImpl<GroupListFluent.ItemsNested<N>> implements GroupListFluent.ItemsNested<N>,Nested<N>{

            private final GroupBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
            ItemsNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) GroupListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<GroupListFluent.MetadataNested<N>> implements GroupListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) GroupListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
