package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ImageListFluent<A extends ImageListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Image... items);
    public A removeFromItems(Image... items);
    public List<Image> getItems();
    public A withItems(List<Image> items);
    public A withItems(Image... items);
    public ImageListFluent.ItemsNested<A> addNewItem();
    public ImageListFluent.ItemsNested<A> addNewItemLike(Image item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ImageListFluent.MetadataNested<A> withNewMetadata();
    public ImageListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ImageListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ImageFluent<ImageListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ImageListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
