package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ImageStreamStatusFluentImpl<A extends ImageStreamStatusFluent<A>> extends BaseFluent<A> implements ImageStreamStatusFluent<A>{

    private String dockerImageRepository;
    private List<VisitableBuilder<? extends NamedTagEventList,?>> tags =  new ArrayList<VisitableBuilder<? extends NamedTagEventList,?>>();

    public ImageStreamStatusFluentImpl(){
    }
    public ImageStreamStatusFluentImpl(ImageStreamStatus instance){
            this.withDockerImageRepository(instance.getDockerImageRepository()); 
            this.withTags(instance.getTags()); 
    }

    public String getDockerImageRepository(){
            return this.dockerImageRepository;
    }

    public A withDockerImageRepository(String dockerImageRepository){
            this.dockerImageRepository=dockerImageRepository; return (A) this;
    }

    public A addToTags(NamedTagEventList... items){
            for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (A)this;
    }

    public A removeFromTags(NamedTagEventList... items){
            for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (A)this;
    }

    public List<NamedTagEventList> getTags(){
            return build(tags);
    }

    public A withTags(List<NamedTagEventList> tags){
            this.tags.clear();
            if (tags != null) {for (NamedTagEventList item : tags){this.addToTags(item);}} return (A) this;
    }

    public A withTags(NamedTagEventList... tags){
            this.tags.clear(); if (tags != null) {for (NamedTagEventList item :tags){ this.addToTags(item);}} return (A) this;
    }

    public ImageStreamStatusFluent.TagsNested<A> addNewTag(){
            return new TagsNestedImpl();
    }

    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item){
            return new TagsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl) o;
            if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
            if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
            return true;
    }


    public class TagsNestedImpl<N> extends NamedTagEventListFluentImpl<ImageStreamStatusFluent.TagsNested<N>> implements ImageStreamStatusFluent.TagsNested<N>,Nested<N>{

            private final NamedTagEventListBuilder builder;
    
            TagsNestedImpl(){
                    this.builder = new NamedTagEventListBuilder(this);
            }
            TagsNestedImpl(NamedTagEventList item){
                    this.builder = new NamedTagEventListBuilder(this, item);
            }
    
    public N endTag(){
            return and();
    }
    public N and(){
            return (N) ImageStreamStatusFluentImpl.this.addToTags(builder.build());
    }

}


}
