package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface OAuthAccessTokenListFluent<A extends OAuthAccessTokenListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(OAuthAccessToken... items);
    public A removeFromItems(OAuthAccessToken... items);
    public List<OAuthAccessToken> getItems();
    public A withItems(List<OAuthAccessToken> items);
    public A withItems(OAuthAccessToken... items);
    public OAuthAccessTokenListFluent.ItemsNested<A> addNewItem();
    public OAuthAccessTokenListFluent.ItemsNested<A> addNewItemLike(OAuthAccessToken item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public OAuthAccessTokenListFluent.MetadataNested<A> withNewMetadata();
    public OAuthAccessTokenListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public OAuthAccessTokenListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,OAuthAccessTokenFluent<OAuthAccessTokenListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<OAuthAccessTokenListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
