package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ProjectListFluent<A extends ProjectListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Project... items);
    public A removeFromItems(Project... items);
    public List<Project> getItems();
    public A withItems(List<Project> items);
    public A withItems(Project... items);
    public ProjectListFluent.ItemsNested<A> addNewItem();
    public ProjectListFluent.ItemsNested<A> addNewItemLike(Project item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ProjectListFluent.MetadataNested<A> withNewMetadata();
    public ProjectListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ProjectListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ProjectFluent<ProjectListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ProjectListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
