package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class RouteIngressBuilder extends RouteIngressFluentImpl<RouteIngressBuilder> implements VisitableBuilder<RouteIngress,RouteIngressBuilder>{

    RouteIngressFluent<?> fluent;
    Boolean validationEnabled;

    public RouteIngressBuilder(){
            this(true);
    }
    public RouteIngressBuilder(Boolean validationEnabled){
            this(new RouteIngress(), validationEnabled);
    }
    public RouteIngressBuilder(RouteIngressFluent<?> fluent){
            this(fluent, true);
    }
    public RouteIngressBuilder(RouteIngressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteIngress(), validationEnabled);
    }
    public RouteIngressBuilder(RouteIngressFluent<?> fluent,RouteIngress instance){
            this(fluent, instance, true);
    }
    public RouteIngressBuilder(RouteIngressFluent<?> fluent,RouteIngress instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withHost(instance.getHost()); 
            fluent.withRouterName(instance.getRouterName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteIngressBuilder(RouteIngress instance){
            this(instance,true);
    }
    public RouteIngressBuilder(RouteIngress instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withHost(instance.getHost()); 
            this.withRouterName(instance.getRouterName()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteIngress build(){
            RouteIngress buildable = new RouteIngress(fluent.getConditions(),fluent.getHost(),fluent.getRouterName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteIngressBuilder that = (RouteIngressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
