package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>> extends BaseFluent<A> implements RouteStatusFluent<A>{

    private List<VisitableBuilder<? extends RouteIngress,?>> ingress =  new ArrayList<VisitableBuilder<? extends RouteIngress,?>>();

    public RouteStatusFluentImpl(){
    }
    public RouteStatusFluentImpl(RouteStatus instance){
            this.withIngress(instance.getIngress()); 
    }

    public A addToIngress(RouteIngress... items){
            for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(RouteIngress... items){
            for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }

    public List<RouteIngress> getIngress(){
            return build(ingress);
    }

    public A withIngress(List<RouteIngress> ingress){
            this.ingress.clear();
            if (ingress != null) {for (RouteIngress item : ingress){this.addToIngress(item);}} return (A) this;
    }

    public A withIngress(RouteIngress... ingress){
            this.ingress.clear(); if (ingress != null) {for (RouteIngress item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public RouteStatusFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item){
            return new IngressNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            return true;
    }


    public class IngressNestedImpl<N> extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>> implements RouteStatusFluent.IngressNested<N>,Nested<N>{

            private final RouteIngressBuilder builder;
    
            IngressNestedImpl(){
                    this.builder = new RouteIngressBuilder(this);
            }
            IngressNestedImpl(RouteIngress item){
                    this.builder = new RouteIngressBuilder(this, item);
            }
    
    public N endIngress(){
            return and();
    }
    public N and(){
            return (N) RouteStatusFluentImpl.this.addToIngress(builder.build());
    }

}


}
