package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ScopeRestrictionFluentImpl<A extends ScopeRestrictionFluent<A>> extends BaseFluent<A> implements ScopeRestrictionFluent<A>{

    private VisitableBuilder<? extends ClusterRoleScopeRestriction,?> clusterRole;
    private List<String> literals = new ArrayList<String>();

    public ScopeRestrictionFluentImpl(){
    }
    public ScopeRestrictionFluentImpl(ScopeRestriction instance){
            this.withClusterRole(instance.getClusterRole()); 
            this.withLiterals(instance.getLiterals()); 
    }

    public ClusterRoleScopeRestriction getClusterRole(){
            return this.clusterRole!=null?this.clusterRole.build():null;
    }

    public A withClusterRole(ClusterRoleScopeRestriction clusterRole){
            if (clusterRole!=null){ this.clusterRole= new ClusterRoleScopeRestrictionBuilder(clusterRole); _visitables.add(this.clusterRole);} return (A) this;
    }

    public ScopeRestrictionFluent.ClusterRoleNested<A> withNewClusterRole(){
            return new ClusterRoleNestedImpl();
    }

    public ScopeRestrictionFluent.ClusterRoleNested<A> withNewClusterRoleLike(ClusterRoleScopeRestriction item){
            return new ClusterRoleNestedImpl(item);
    }

    public ScopeRestrictionFluent.ClusterRoleNested<A> editClusterRole(){
            return withNewClusterRoleLike(getClusterRole());
    }

    public A addToLiterals(String... items){
            for (String item : items) {this.literals.add(item);} return (A)this;
    }

    public A removeFromLiterals(String... items){
            for (String item : items) {this.literals.remove(item);} return (A)this;
    }

    public List<String> getLiterals(){
            return this.literals;
    }

    public A withLiterals(List<String> literals){
            this.literals.clear();
            if (literals != null) {for (String item : literals){this.addToLiterals(item);}} return (A) this;
    }

    public A withLiterals(String... literals){
            this.literals.clear(); if (literals != null) {for (String item :literals){ this.addToLiterals(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ScopeRestrictionFluentImpl that = (ScopeRestrictionFluentImpl) o;
            if (clusterRole != null ? !clusterRole.equals(that.clusterRole) :that.clusterRole != null) return false;
            if (literals != null ? !literals.equals(that.literals) :that.literals != null) return false;
            return true;
    }


    public class ClusterRoleNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<ScopeRestrictionFluent.ClusterRoleNested<N>> implements ScopeRestrictionFluent.ClusterRoleNested<N>,Nested<N>{

            private final ClusterRoleScopeRestrictionBuilder builder;
    
            ClusterRoleNestedImpl(){
                    this.builder = new ClusterRoleScopeRestrictionBuilder(this);
            }
            ClusterRoleNestedImpl(ClusterRoleScopeRestriction item){
                    this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
            }
    
    public N and(){
            return (N) ScopeRestrictionFluentImpl.this.withClusterRole(builder.build());
    }
    public N endClusterRole(){
            return and();
    }

}


}
