package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class TemplateListFluentImpl<A extends TemplateListFluent<A>> extends BaseFluent<A> implements TemplateListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Template,?>> items =  new ArrayList<VisitableBuilder<? extends Template,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public TemplateListFluentImpl(){
    }
    public TemplateListFluentImpl(TemplateList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Template> getItems(){
            return build(items);
    }

    public A withItems(List<Template> items){
            this.items.clear();
            if (items != null) {for (Template item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Template... items){
            this.items.clear(); if (items != null) {for (Template item :items){ this.addToItems(item);}} return (A) this;
    }

    public TemplateListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public TemplateListFluent.ItemsNested<A> addNewItemLike(Template item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public TemplateListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public TemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public TemplateListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TemplateListFluentImpl that = (TemplateListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends TemplateFluentImpl<TemplateListFluent.ItemsNested<N>> implements TemplateListFluent.ItemsNested<N>,Nested<N>{

            private final TemplateBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
            ItemsNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) TemplateListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<TemplateListFluent.MetadataNested<N>> implements TemplateListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) TemplateListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
