package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>> extends BaseFluent<A> implements ContainerStateFluent<A>{

    private VisitableBuilder<? extends ContainerStateRunning,?> running;
    private VisitableBuilder<? extends ContainerStateTerminated,?> terminated;
    private VisitableBuilder<? extends ContainerStateWaiting,?> waiting;

    public ContainerStateFluentImpl(){
    }
    public ContainerStateFluentImpl(ContainerState instance){
            this.withRunning(instance.getRunning()); 
            this.withTerminated(instance.getTerminated()); 
            this.withWaiting(instance.getWaiting()); 
    }

    public ContainerStateRunning getRunning(){
            return this.running!=null?this.running.build():null;
    }

    public A withRunning(ContainerStateRunning running){
            if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.add(this.running);} return (A) this;
    }

    public ContainerStateFluent.RunningNested<A> withNewRunning(){
            return new RunningNestedImpl();
    }

    public ContainerStateFluent.RunningNested<A> withNewRunningLike(ContainerStateRunning item){
            return new RunningNestedImpl(item);
    }

    public ContainerStateFluent.RunningNested<A> editRunning(){
            return withNewRunningLike(getRunning());
    }

    public A withNewRunning(String startedAt){
            return (A)withRunning(new ContainerStateRunning(startedAt));
    }

    public ContainerStateTerminated getTerminated(){
            return this.terminated!=null?this.terminated.build():null;
    }

    public A withTerminated(ContainerStateTerminated terminated){
            if (terminated!=null){ this.terminated= new ContainerStateTerminatedBuilder(terminated); _visitables.add(this.terminated);} return (A) this;
    }

    public ContainerStateFluent.TerminatedNested<A> withNewTerminated(){
            return new TerminatedNestedImpl();
    }

    public ContainerStateFluent.TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item){
            return new TerminatedNestedImpl(item);
    }

    public ContainerStateFluent.TerminatedNested<A> editTerminated(){
            return withNewTerminatedLike(getTerminated());
    }

    public ContainerStateWaiting getWaiting(){
            return this.waiting!=null?this.waiting.build():null;
    }

    public A withWaiting(ContainerStateWaiting waiting){
            if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.add(this.waiting);} return (A) this;
    }

    public ContainerStateFluent.WaitingNested<A> withNewWaiting(){
            return new WaitingNestedImpl();
    }

    public ContainerStateFluent.WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item){
            return new WaitingNestedImpl(item);
    }

    public ContainerStateFluent.WaitingNested<A> editWaiting(){
            return withNewWaitingLike(getWaiting());
    }

    public A withNewWaiting(String message,String reason){
            return (A)withWaiting(new ContainerStateWaiting(message, reason));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
            if (running != null ? !running.equals(that.running) :that.running != null) return false;
            if (terminated != null ? !terminated.equals(that.terminated) :that.terminated != null) return false;
            if (waiting != null ? !waiting.equals(that.waiting) :that.waiting != null) return false;
            return true;
    }


    public class RunningNestedImpl<N> extends ContainerStateRunningFluentImpl<ContainerStateFluent.RunningNested<N>> implements ContainerStateFluent.RunningNested<N>,Nested<N>{

            private final ContainerStateRunningBuilder builder;
    
            RunningNestedImpl(){
                    this.builder = new ContainerStateRunningBuilder(this);
            }
            RunningNestedImpl(ContainerStateRunning item){
                    this.builder = new ContainerStateRunningBuilder(this, item);
            }
    
    public N and(){
            return (N) ContainerStateFluentImpl.this.withRunning(builder.build());
    }
    public N endRunning(){
            return and();
    }

}
    public class TerminatedNestedImpl<N> extends ContainerStateTerminatedFluentImpl<ContainerStateFluent.TerminatedNested<N>> implements ContainerStateFluent.TerminatedNested<N>,Nested<N>{

            private final ContainerStateTerminatedBuilder builder;
    
            TerminatedNestedImpl(ContainerStateTerminated item){
                    this.builder = new ContainerStateTerminatedBuilder(this, item);
            }
            TerminatedNestedImpl(){
                    this.builder = new ContainerStateTerminatedBuilder(this);
            }
    
    public N endTerminated(){
            return and();
    }
    public N and(){
            return (N) ContainerStateFluentImpl.this.withTerminated(builder.build());
    }

}
    public class WaitingNestedImpl<N> extends ContainerStateWaitingFluentImpl<ContainerStateFluent.WaitingNested<N>> implements ContainerStateFluent.WaitingNested<N>,Nested<N>{

            private final ContainerStateWaitingBuilder builder;
    
            WaitingNestedImpl(){
                    this.builder = new ContainerStateWaitingBuilder(this);
            }
            WaitingNestedImpl(ContainerStateWaiting item){
                    this.builder = new ContainerStateWaitingBuilder(this, item);
            }
    
    public N and(){
            return (N) ContainerStateFluentImpl.this.withWaiting(builder.build());
    }
    public N endWaiting(){
            return and();
    }

}


}
