package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeprecatedDownwardAPIVolumeSourceFluentImpl<A extends DeprecatedDownwardAPIVolumeSourceFluent<A>> extends BaseFluent<A> implements DeprecatedDownwardAPIVolumeSourceFluent<A>{

    private List<VisitableBuilder<? extends DeprecatedDownwardAPIVolumeFile,?>> items =  new ArrayList<VisitableBuilder<? extends DeprecatedDownwardAPIVolumeFile,?>>();

    public DeprecatedDownwardAPIVolumeSourceFluentImpl(){
    }
    public DeprecatedDownwardAPIVolumeSourceFluentImpl(DeprecatedDownwardAPIVolumeSource instance){
            this.withItems(instance.getItems()); 
    }

    public A addToItems(DeprecatedDownwardAPIVolumeFile... items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(DeprecatedDownwardAPIVolumeFile... items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<DeprecatedDownwardAPIVolumeFile> getItems(){
            return build(items);
    }

    public A withItems(List<DeprecatedDownwardAPIVolumeFile> items){
            this.items.clear();
            if (items != null) {for (DeprecatedDownwardAPIVolumeFile item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(DeprecatedDownwardAPIVolumeFile... items){
            this.items.clear(); if (items != null) {for (DeprecatedDownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DeprecatedDownwardAPIVolumeFile item){
            return new ItemsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeprecatedDownwardAPIVolumeSourceFluentImpl that = (DeprecatedDownwardAPIVolumeSourceFluentImpl) o;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends DeprecatedDownwardAPIVolumeFileFluentImpl<DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<N>> implements DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<N>,Nested<N>{

            private final DeprecatedDownwardAPIVolumeFileBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new DeprecatedDownwardAPIVolumeFileBuilder(this);
            }
            ItemsNestedImpl(DeprecatedDownwardAPIVolumeFile item){
                    this.builder = new DeprecatedDownwardAPIVolumeFileBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) DeprecatedDownwardAPIVolumeSourceFluentImpl.this.addToItems(builder.build());
    }

}


}
