package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class EmptyDirVolumeSourceBuilder extends EmptyDirVolumeSourceFluentImpl<EmptyDirVolumeSourceBuilder> implements VisitableBuilder<EmptyDirVolumeSource,EmptyDirVolumeSourceBuilder>{

    EmptyDirVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public EmptyDirVolumeSourceBuilder(){
            this(true);
    }
    public EmptyDirVolumeSourceBuilder(Boolean validationEnabled){
            this(new EmptyDirVolumeSource(), validationEnabled);
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EmptyDirVolumeSource(), validationEnabled);
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,EmptyDirVolumeSource instance){
            this(fluent, instance, true);
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSourceFluent<?> fluent,EmptyDirVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMedium(instance.getMedium()); 
            this.validationEnabled = validationEnabled; 
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSource instance){
            this(instance,true);
    }
    public EmptyDirVolumeSourceBuilder(EmptyDirVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMedium(instance.getMedium()); 
            this.validationEnabled = validationEnabled; 
    }

    public EmptyDirVolumeSource build(){
            EmptyDirVolumeSource buildable = new EmptyDirVolumeSource(fluent.getMedium());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EmptyDirVolumeSourceBuilder that = (EmptyDirVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
