package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class EndpointsFluentImpl<A extends EndpointsFluent<A>> extends BaseFluent<A> implements EndpointsFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends EndpointSubset,?>> subsets =  new ArrayList<VisitableBuilder<? extends EndpointSubset,?>>();

    public EndpointsFluentImpl(){
    }
    public EndpointsFluentImpl(Endpoints instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSubsets(instance.getSubsets()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public EndpointsFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public EndpointsFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A addToSubsets(EndpointSubset... items){
            for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }

    public A removeFromSubsets(EndpointSubset... items){
            for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.remove(builder);this.subsets.remove(builder);} return (A)this;
    }

    public List<EndpointSubset> getSubsets(){
            return build(subsets);
    }

    public A withSubsets(List<EndpointSubset> subsets){
            this.subsets.clear();
            if (subsets != null) {for (EndpointSubset item : subsets){this.addToSubsets(item);}} return (A) this;
    }

    public A withSubsets(EndpointSubset... subsets){
            this.subsets.clear(); if (subsets != null) {for (EndpointSubset item :subsets){ this.addToSubsets(item);}} return (A) this;
    }

    public EndpointsFluent.SubsetsNested<A> addNewSubset(){
            return new SubsetsNestedImpl();
    }

    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item){
            return new SubsetsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointsFluentImpl that = (EndpointsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>> implements EndpointsFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) EndpointsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SubsetsNestedImpl<N> extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>> implements EndpointsFluent.SubsetsNested<N>,Nested<N>{

            private final EndpointSubsetBuilder builder;
    
            SubsetsNestedImpl(){
                    this.builder = new EndpointSubsetBuilder(this);
            }
            SubsetsNestedImpl(EndpointSubset item){
                    this.builder = new EndpointSubsetBuilder(this, item);
            }
    
    public N and(){
            return (N) EndpointsFluentImpl.this.addToSubsets(builder.build());
    }
    public N endSubset(){
            return and();
    }

}


}
