package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Pattern;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EnvVarFluent<A extends EnvVarFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public String getValue();
    public A withValue(String value);
    public EnvVarSource getValueFrom();
    public A withValueFrom(EnvVarSource valueFrom);
    public EnvVarFluent.ValueFromNested<A> withNewValueFrom();
    public EnvVarFluent.ValueFromNested<A> withNewValueFromLike(EnvVarSource item);
    public EnvVarFluent.ValueFromNested<A> editValueFrom();

    public interface ValueFromNested<N> extends Nested<N>,EnvVarSourceFluent<EnvVarFluent.ValueFromNested<N>>{

        
    public N endValueFrom();    public N and();
}


}
