package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NodeDaemonEndpointsFluent<A extends NodeDaemonEndpointsFluent<A>> extends Fluent<A>{


    public DaemonEndpoint getKubeletEndpoint();
    public A withKubeletEndpoint(DaemonEndpoint kubeletEndpoint);
    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpoint();
    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpointLike(DaemonEndpoint item);
    public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editKubeletEndpoint();
    public A withNewKubeletEndpoint(Integer port);

    public interface KubeletEndpointNested<N> extends Nested<N>,DaemonEndpointFluent<NodeDaemonEndpointsFluent.KubeletEndpointNested<N>>{

        
    public N and();    public N endKubeletEndpoint();
}


}
