package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>> extends BaseFluent<A> implements ResourceFieldSelectorFluent<A>{

    private String containerName;
    private VisitableBuilder<? extends Quantity,?> divisor;
    private String resource;

    public ResourceFieldSelectorFluentImpl(){
    }
    public ResourceFieldSelectorFluentImpl(ResourceFieldSelector instance){
            this.withContainerName(instance.getContainerName()); 
            this.withDivisor(instance.getDivisor()); 
            this.withResource(instance.getResource()); 
    }

    public String getContainerName(){
            return this.containerName;
    }

    public A withContainerName(String containerName){
            this.containerName=containerName; return (A) this;
    }

    public Quantity getDivisor(){
            return this.divisor!=null?this.divisor.build():null;
    }

    public A withDivisor(Quantity divisor){
            if (divisor!=null){ this.divisor= new QuantityBuilder(divisor); _visitables.add(this.divisor);} return (A) this;
    }

    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor(){
            return new DivisorNestedImpl();
    }

    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item){
            return new DivisorNestedImpl(item);
    }

    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor(){
            return withNewDivisorLike(getDivisor());
    }

    public A withNewDivisor(String amount){
            return (A)withDivisor(new Quantity(amount));
    }

    public A withNewDivisor(String amount,String format){
            return (A)withDivisor(new Quantity(amount, format));
    }

    public String getResource(){
            return this.resource;
    }

    public A withResource(String resource){
            this.resource=resource; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl) o;
            if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
            if (divisor != null ? !divisor.equals(that.divisor) :that.divisor != null) return false;
            if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
            return true;
    }


    public class DivisorNestedImpl<N> extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>> implements ResourceFieldSelectorFluent.DivisorNested<N>,Nested<N>{

            private final QuantityBuilder builder;
    
            DivisorNestedImpl(){
                    this.builder = new QuantityBuilder(this);
            }
            DivisorNestedImpl(Quantity item){
                    this.builder = new QuantityBuilder(this, item);
            }
    
    public N endDivisor(){
            return and();
    }
    public N and(){
            return (N) ResourceFieldSelectorFluentImpl.this.withDivisor(builder.build());
    }

}


}
