package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ResourceQuotaListFluent<A extends ResourceQuotaListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ResourceQuota... items);
    public A removeFromItems(ResourceQuota... items);
    public List<ResourceQuota> getItems();
    public A withItems(List<ResourceQuota> items);
    public A withItems(ResourceQuota... items);
    public ResourceQuotaListFluent.ItemsNested<A> addNewItem();
    public ResourceQuotaListFluent.ItemsNested<A> addNewItemLike(ResourceQuota item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadata();
    public ResourceQuotaListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ResourceQuotaListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ResourceQuotaFluent<ResourceQuotaListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ResourceQuotaListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
