package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class SELinuxContextStrategyOptionsFluentImpl<A extends SELinuxContextStrategyOptionsFluent<A>> extends BaseFluent<A> implements SELinuxContextStrategyOptionsFluent<A>{

    private VisitableBuilder<? extends SELinuxOptions,?> seLinuxOptions;
    private String type;

    public SELinuxContextStrategyOptionsFluentImpl(){
    }
    public SELinuxContextStrategyOptionsFluentImpl(SELinuxContextStrategyOptions instance){
            this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            this.withType(instance.getType()); 
    }

    public SELinuxOptions getSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions){
            if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (A) this;
    }

    public SELinuxContextStrategyOptionsFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
            return new SeLinuxOptionsNestedImpl();
    }

    public SELinuxContextStrategyOptionsFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item){
            return new SeLinuxOptionsNestedImpl(item);
    }

    public SELinuxContextStrategyOptionsFluent.SeLinuxOptionsNested<A> editSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user){
            return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SELinuxContextStrategyOptionsFluentImpl that = (SELinuxContextStrategyOptionsFluentImpl) o;
            if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<SELinuxContextStrategyOptionsFluent.SeLinuxOptionsNested<N>> implements SELinuxContextStrategyOptionsFluent.SeLinuxOptionsNested<N>,Nested<N>{

            private final SELinuxOptionsBuilder builder;
    
            SeLinuxOptionsNestedImpl(){
                    this.builder = new SELinuxOptionsBuilder(this);
            }
            SeLinuxOptionsNestedImpl(SELinuxOptions item){
                    this.builder = new SELinuxOptionsBuilder(this, item);
            }
    
    public N endSeLinuxOptions(){
            return and();
    }
    public N and(){
            return (N) SELinuxContextStrategyOptionsFluentImpl.this.withSeLinuxOptions(builder.build());
    }

}


}
