package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ServiceListFluentImpl<A extends ServiceListFluent<A>> extends BaseFluent<A> implements ServiceListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends Service,?>> items =  new ArrayList<VisitableBuilder<? extends Service,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public ServiceListFluentImpl(){
    }
    public ServiceListFluentImpl(ServiceList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<Service> getItems(){
            return build(items);
    }

    public A withItems(List<Service> items){
            this.items.clear();
            if (items != null) {for (Service item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(Service... items){
            this.items.clear(); if (items != null) {for (Service item :items){ this.addToItems(item);}} return (A) this;
    }

    public ServiceListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ServiceListFluent.ItemsNested<A> addNewItemLike(Service item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ServiceListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ServiceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public ServiceListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceListFluentImpl that = (ServiceListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ServiceFluentImpl<ServiceListFluent.ItemsNested<N>> implements ServiceListFluent.ItemsNested<N>,Nested<N>{

            private final ServiceBuilder builder;
    
            ItemsNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) ServiceListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<ServiceListFluent.MetadataNested<N>> implements ServiceListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) ServiceListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
