package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class SupplementalGroupsStrategyOptionsBuilder extends SupplementalGroupsStrategyOptionsFluentImpl<SupplementalGroupsStrategyOptionsBuilder> implements VisitableBuilder<SupplementalGroupsStrategyOptions,SupplementalGroupsStrategyOptionsBuilder>{

    SupplementalGroupsStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SupplementalGroupsStrategyOptionsBuilder(){
            this(true);
    }
    public SupplementalGroupsStrategyOptionsBuilder(Boolean validationEnabled){
            this(new SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance){
            this(fluent, instance, true);
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance){
            this(instance,true);
    }
    public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public SupplementalGroupsStrategyOptions build(){
            SupplementalGroupsStrategyOptions buildable = new SupplementalGroupsStrategyOptions(fluent.getRanges(),fluent.getType());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SupplementalGroupsStrategyOptionsBuilder that = (SupplementalGroupsStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
