package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class VolumeMountBuilder extends VolumeMountFluentImpl<VolumeMountBuilder> implements VisitableBuilder<VolumeMount,VolumeMountBuilder>{

    VolumeMountFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeMountBuilder(){
            this(true);
    }
    public VolumeMountBuilder(Boolean validationEnabled){
            this(new VolumeMount(), validationEnabled);
    }
    public VolumeMountBuilder(VolumeMountFluent<?> fluent){
            this(fluent, true);
    }
    public VolumeMountBuilder(VolumeMountFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolumeMount(), validationEnabled);
    }
    public VolumeMountBuilder(VolumeMountFluent<?> fluent,VolumeMount instance){
            this(fluent, instance, true);
    }
    public VolumeMountBuilder(VolumeMountFluent<?> fluent,VolumeMount instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMountPath(instance.getMountPath()); 
            fluent.withName(instance.getName()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withSubPath(instance.getSubPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolumeMountBuilder(VolumeMount instance){
            this(instance,true);
    }
    public VolumeMountBuilder(VolumeMount instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMountPath(instance.getMountPath()); 
            this.withName(instance.getName()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withSubPath(instance.getSubPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public VolumeMount build(){
            VolumeMount buildable = new VolumeMount(fluent.getMountPath(),fluent.getName(),fluent.isReadOnly(),fluent.getSubPath());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeMountBuilder that = (VolumeMountBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
