package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class DaemonSetStatusFluentImpl<A extends DaemonSetStatusFluent<A>> extends BaseFluent<A> implements DaemonSetStatusFluent<A>{

    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberMisscheduled;

    public DaemonSetStatusFluentImpl(){
    }
    public DaemonSetStatusFluentImpl(DaemonSetStatus instance){
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
            this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
    }

    public Integer getCurrentNumberScheduled(){
            return this.currentNumberScheduled;
    }

    public A withCurrentNumberScheduled(Integer currentNumberScheduled){
            this.currentNumberScheduled=currentNumberScheduled; return (A) this;
    }

    public Integer getDesiredNumberScheduled(){
            return this.desiredNumberScheduled;
    }

    public A withDesiredNumberScheduled(Integer desiredNumberScheduled){
            this.desiredNumberScheduled=desiredNumberScheduled; return (A) this;
    }

    public Integer getNumberMisscheduled(){
            return this.numberMisscheduled;
    }

    public A withNumberMisscheduled(Integer numberMisscheduled){
            this.numberMisscheduled=numberMisscheduled; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl) o;
            if (currentNumberScheduled != null ? !currentNumberScheduled.equals(that.currentNumberScheduled) :that.currentNumberScheduled != null) return false;
            if (desiredNumberScheduled != null ? !desiredNumberScheduled.equals(that.desiredNumberScheduled) :that.desiredNumberScheduled != null) return false;
            if (numberMisscheduled != null ? !numberMisscheduled.equals(that.numberMisscheduled) :that.numberMisscheduled != null) return false;
            return true;
    }




}
