package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface HTTPIngressPathFluent<A extends HTTPIngressPathFluent<A>> extends Fluent<A>{


    public IngressBackend getBackend();
    public A withBackend(IngressBackend backend);
    public HTTPIngressPathFluent.BackendNested<A> withNewBackend();
    public HTTPIngressPathFluent.BackendNested<A> withNewBackendLike(IngressBackend item);
    public HTTPIngressPathFluent.BackendNested<A> editBackend();
    public String getPath();
    public A withPath(String path);

    public interface BackendNested<N> extends Nested<N>,IngressBackendFluent<HTTPIngressPathFluent.BackendNested<N>>{

        
    public N and();    public N endBackend();
}


}
