package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface PetSetFluent<A extends PetSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PetSetFluent.MetadataNested<A> withNewMetadata();
    public PetSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PetSetFluent.MetadataNested<A> editMetadata();
    public PetSetSpec getSpec();
    public A withSpec(PetSetSpec spec);
    public PetSetFluent.SpecNested<A> withNewSpec();
    public PetSetFluent.SpecNested<A> withNewSpecLike(PetSetSpec item);
    public PetSetFluent.SpecNested<A> editSpec();
    public PetSetStatus getStatus();
    public A withStatus(PetSetStatus status);
    public PetSetFluent.StatusNested<A> withNewStatus();
    public PetSetFluent.StatusNested<A> withNewStatusLike(PetSetStatus item);
    public PetSetFluent.StatusNested<A> editStatus();
    public A withNewStatus(Long observedGeneration,Integer replicas);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PetSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PetSetSpecFluent<PetSetFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,PetSetStatusFluent<PetSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
