package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ClusterPolicyBindingListFluent<A extends ClusterPolicyBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ClusterPolicyBinding... items);
    public A removeFromItems(ClusterPolicyBinding... items);
    public List<ClusterPolicyBinding> getItems();
    public A withItems(List<ClusterPolicyBinding> items);
    public A withItems(ClusterPolicyBinding... items);
    public ClusterPolicyBindingListFluent.ItemsNested<A> addNewItem();
    public ClusterPolicyBindingListFluent.ItemsNested<A> addNewItemLike(ClusterPolicyBinding item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ClusterPolicyBindingListFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ClusterPolicyBindingListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ClusterPolicyBindingFluent<ClusterPolicyBindingListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ClusterPolicyBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
