package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface DeploymentTriggerImageChangeParamsFluent<A extends DeploymentTriggerImageChangeParamsFluent<A>> extends Fluent<A>{


    public Boolean isAutomatic();
    public A withAutomatic(Boolean automatic);
    public A addToContainerNames(String... items);
    public A removeFromContainerNames(String... items);
    public List<String> getContainerNames();
    public A withContainerNames(List<String> containerNames);
    public A withContainerNames(String... containerNames);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFrom();
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editFrom();
    public String getLastTriggeredImage();
    public A withLastTriggeredImage(String lastTriggeredImage);

    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<DeploymentTriggerImageChangeParamsFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}


}
