package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedRoleFluent<A extends NamedRoleFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Role getRole();
    public A withRole(Role role);
    public NamedRoleFluent.RoleNested<A> withNewRole();
    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item);
    public NamedRoleFluent.RoleNested<A> editRole();

    public interface RoleNested<N> extends Nested<N>,RoleFluent<NamedRoleFluent.RoleNested<N>>{

        
    public N endRole();    public N and();
}


}
