package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface OAuthAuthorizeTokenFluent<A extends OAuthAuthorizeTokenFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getClientName();
    public A withClientName(String clientName);
    public Long getExpiresIn();
    public A withExpiresIn(Long expiresIn);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editMetadata();
    public String getRedirectURI();
    public A withRedirectURI(String redirectURI);
    public A addToScopes(String... items);
    public A removeFromScopes(String... items);
    public List<String> getScopes();
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public String getState();
    public A withState(String state);
    public String getUserName();
    public A withUserName(String userName);
    public String getUserUID();
    public A withUserUID(String userUID);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthAuthorizeTokenFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
