package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.String;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public class RoutePortFluentImpl<A extends RoutePortFluent<A>> extends BaseFluent<A> implements RoutePortFluent<A>{

    private VisitableBuilder<? extends IntOrString,?> targetPort;

    public RoutePortFluentImpl(){
    }
    public RoutePortFluentImpl(RoutePort instance){
            this.withTargetPort(instance.getTargetPort()); 
    }

    public IntOrString getTargetPort(){
            return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(IntOrString targetPort){
            if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.add(this.targetPort);} return (A) this;
    }

    public RoutePortFluent.TargetPortNested<A> withNewTargetPort(){
            return new TargetPortNestedImpl();
    }

    public RoutePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item){
            return new TargetPortNestedImpl(item);
    }

    public RoutePortFluent.TargetPortNested<A> editTargetPort(){
            return withNewTargetPortLike(getTargetPort());
    }

    public A withNewTargetPort(String strVal){
            return (A)withTargetPort(new IntOrString(strVal));
    }

    public A withNewTargetPort(Integer intVal){
            return (A)withTargetPort(new IntOrString(intVal));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RoutePortFluentImpl that = (RoutePortFluentImpl) o;
            if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
            return true;
    }


    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<RoutePortFluent.TargetPortNested<N>> implements RoutePortFluent.TargetPortNested<N>,Nested<N>{

            private final IntOrStringBuilder builder;
    
            TargetPortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
            TargetPortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
    
    public N endTargetPort(){
            return and();
    }
    public N and(){
            return (N) RoutePortFluentImpl.this.withTargetPort(builder.build());
    }

}


}
