package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class LimitRangeBuilder extends LimitRangeFluentImpl<LimitRangeBuilder> implements VisitableBuilder<LimitRange,LimitRangeBuilder>{

    LimitRangeFluent<?> fluent;
    Boolean validationEnabled;

    public LimitRangeBuilder(){
            this(true);
    }
    public LimitRangeBuilder(Boolean validationEnabled){
            this(new LimitRange(), validationEnabled);
    }
    public LimitRangeBuilder(LimitRangeFluent<?> fluent){
            this(fluent, true);
    }
    public LimitRangeBuilder(LimitRangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LimitRange(), validationEnabled);
    }
    public LimitRangeBuilder(LimitRangeFluent<?> fluent,LimitRange instance){
            this(fluent, instance, true);
    }
    public LimitRangeBuilder(LimitRangeFluent<?> fluent,LimitRange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public LimitRangeBuilder(LimitRange instance){
            this(instance,true);
    }
    public LimitRangeBuilder(LimitRange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public LimitRange build(){
            LimitRange buildable = new LimitRange(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LimitRangeBuilder that = (LimitRangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
