package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface ResourceFieldSelectorFluent<A extends ResourceFieldSelectorFluent<A>> extends Fluent<A>{


    public String getContainerName();
    public A withContainerName(String containerName);
    public Quantity getDivisor();
    public A withDivisor(Quantity divisor);
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor();
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item);
    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor();
    public A withNewDivisor(String amount);
    public A withNewDivisor(String amount,String format);
    public String getResource();
    public A withResource(String resource);

    public interface DivisorNested<N> extends Nested<N>,QuantityFluent<ResourceFieldSelectorFluent.DivisorNested<N>>{

        
    public N endDivisor();    public N and();
}


}
